<x-layout-dashboard title="{{__('Test Messages')}}">
    <div class="content-body">
            <!-- row -->
			<div class="container-fluid">
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.3.3/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.3.3/dist/leaflet.js"></script>
    @if (session()->has('alert'))
        <x-alert>
            @slot('type', session('alert')['type'])
            @slot('msg', session('alert')['msg'])
        </x-alert>
    @endif
    @if ($errors->any())
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger">
                    <i class="bi bi-exclamation-circle-fill"></i>

                </div>
                <div class="ms-3">
                    <p>The given data was invalid.</p>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

        </div>
    @endif
    {{-- form --}}
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">{{__('Test Message')}}</h5>
                </div>
                @if (!session()->has('selectedDevice') || !session()->has('selectedDevice'))
                    <div class="alert alert-danger">
                        <ul>
                            <li>{{__('Please select a device and a message to test')}}</li>
                        </ul>
                    </div>
                @else
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="card shadow-none border">
                                <div class="card-body">
                                    <form class="row g-3" action="{{ route('messagetest') }}" method="POST">
                                        @csrf
                                        <div class="col-12">
                                            <label class="form-label">{{__('Sender')}}</label>
                                            <input name="sender"
                                                value="{{ session()->get('selectedDevice')['device_body'] }}"
                                                type="text" class="form-control" readonly>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">{{__('Receiver Number')}}</label>
                                            <textarea placeholder="628xxx|628xxx|628xxx" class="form-control" name="number" id="" cols="20"
                                                rows="2"></textarea>
                                            {{-- <input name="number" value="" type="number" class="form-control"
                                                required> --}}
                                        </div>
                                        <div class="col-12">
                                            <label for="type" class="form-label">{{__('Type Message')}}</label>
                                            <select name="type" id="type" class="js-states form-control"
                                                tabindex="-1" required>
                                                <option value="" selected disabled>{{__('Select One')}}</option>
                                                <option value="text">{{__('Text Message')}}</option>
                                                <option value="media">{{__('Media Message')}}</option>
                                                <option value="poll">{{__('Poll Message')}}</option>
                                                <option value="list">{{__('List Message')}}</option>
												<option value="location">{{__('Location Message')}}</option>
												<option value="vcard">{{__('VCard Message')}}</option>
                                                <option value="button">{{__('Button Message ( Only WEB & IOS )')}}</option>
                                                <option value="template">{{__('Template Message ( Only WEB & IOS )')}}</option>

                                            </select>
                                        </div>
                                        <div class="col-12 ajaxplace ">

                                        </div>
                                        {{-- button --}}
                                        <div class="col-12 text-center">
                                            <button type="submit" class="btn btn-info btn-sm text-white px-5">{{__('Send Message')}}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>


                        </div>

                    </div>
                @endif
                <!--end row-->
            </div>
        </div>
    </div>
    </div>
    {{-- end form --}}
        </div>
    </div>
</x-layout-dashboard>
<script>
    $('#type').on('change', () => {
        const type = $('#type').val();
        $.ajax({
            url: `/form-message/${type}`,

            type: "GET",
            dataType: "html",
            success: (result) => {
                $(".ajaxplace").html(result);
            },
            error: (error) => {
                console.log(error);
            },
        });
    })
</script>
